/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.AusSystemEventLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardCommitStatus;
import com.ibm.hsc.iw.WizardConstants;
import com.ibm.hsc.iw.WizardFrameTasklet;
import com.ibm.hsc.iw.WizardTasksHistory;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.util.Locale;

public class WizardCommitThread
implements Runnable,
WizardConstants {
    private static final String TRACE_MASKD = "JIWZCMTD";
    private static final String TRACE_MASKF = "JIWZCMTF";
    private static final String TRACE_MASKT = "JIWZCMTT";
    public static final String WIZARD_EVENT_NAME = "SetupWizard";
    private static final String WIZARD_STATUS_COMPLETED_REBOOT = "completed_reboot";
    private static final String WIZARD_STATUS_COMPLETED_LOGOUT = "completed_logout";
    private static final String WIZARD_STATUS_COMPLETED = "completed";
    private WizardTasksHistory tasksHistory;
    private WizardFrameTasklet frameTasklet;
    private long lastUniqueIdNum = 0L;

    public WizardCommitThread(WizardTasksHistory wizardTasksHistory, WizardFrameTasklet wizardFrameTasklet) {
        this.tasksHistory = wizardTasksHistory;
        this.frameTasklet = wizardFrameTasklet;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->WizardCommitThread(...)");
        }
    }

    public static void main(String[] stringArray) {
    }

    public void run() {
        Object var1_1 = null;
        WizardCommitStatus wizardCommitStatus = null;
        LocalizableText localizableText = null;
        PanelTaskletRequest panelTaskletRequest = null;
        HSCLocalizableMsg[] hSCLocalizableMsgArray = null;
        for (int i = 0; i < this.tasksHistory.size(); ++i) {
            if (!this.tasksHistory.get(i).getTask().isVisible()) continue;
            if (this.tasksHistory.get(i).getReadyToCommit()) {
                localizableText = this.tasksHistory.get(i).getTask().getDescription();
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "Calling commit() in task " + localizableText.toString(Locale.ENGLISH) + " with token of " + this.tasksHistory.get(i).getLastToken() + ".");
                }
                if ((wizardCommitStatus = this.tasksHistory.get(i).getTask().commit(this.tasksHistory.get(i).getLastToken())) == null) {
                    if (Trace.LEVEL >= 3) {
                        Trace.trace(TRACE_MASKD, "The commit() call returned null.");
                    }
                    wizardCommitStatus = new WizardCommitStatus(false, null);
                } else {
                    if (Trace.LEVEL >= 3) {
                        Trace.trace(TRACE_MASKD, "The commit() call returned " + wizardCommitStatus);
                    }
                    if ((hSCLocalizableMsgArray = wizardCommitStatus.getMessages()) != null) {
                        for (int j = 0; j < hSCLocalizableMsgArray.length; ++j) {
                            new AusSystemEventLog(hSCLocalizableMsgArray[j], WIZARD_EVENT_NAME).writeEntry();
                        }
                    }
                    if (wizardCommitStatus.isRebootRequired()) {
                        this.tasksHistory.setRebootRequired(true);
                    }
                    if (wizardCommitStatus.isReLogonRequired()) {
                        this.tasksHistory.setReLogonRequired(true);
                    }
                }
                wizardCommitStatus.setDescription(localizableText);
                panelTaskletRequest = new PanelTaskletRequest((Object)(this.getUniqueSourceName() + '.' + "FrameUpdateAction"));
                panelTaskletRequest.setData("Source", (Object)this.getUniqueSourceName());
                panelTaskletRequest.setData("Action", (Object)"FrameUpdateAction");
                panelTaskletRequest.setData("Data", (Object)wizardCommitStatus);
                panelTaskletRequest.setData("Data2", (Object)localizableText);
                try {
                    this.frameTasklet.postRequest("WizardFrame", panelTaskletRequest);
                }
                catch (TaskletException taskletException) {
                    if (Trace.LEVEL >= 3) {
                        Trace.trace(TRACE_MASKD, "TaskletException while posting request to update the status panel: " + (Object)((Object)taskletException));
                    }
                    new AusMicrocodeLog(LOG_INFO, 11, taskletException).writeEntry(null);
                }
                continue;
            }
            if (Trace.LEVEL < 3) continue;
            Trace.trace(TRACE_MASKD, "Skipping the commit() call for task " + this.tasksHistory.get(i).getTask().getDescription().toString(Locale.ENGLISH) + ".");
        }
        this.tasksHistory.setCommitted(true);
        try {
            if (this.tasksHistory.isRebootRequired()) {
                WizardFrameTasklet.saveWizardStatus(WIZARD_STATUS_COMPLETED_REBOOT);
            } else if (this.tasksHistory.isReLogonRequired()) {
                WizardFrameTasklet.saveWizardStatus(WIZARD_STATUS_COMPLETED_LOGOUT);
            } else {
                WizardFrameTasklet.saveWizardStatus(WIZARD_STATUS_COMPLETED);
            }
        }
        catch (HException hException) {
            if (Trace.LEVEL >= 2) {
                Trace.trace(TRACE_MASKF, "HException thrown by saveWizardStatus() call : " + (Object)((Object)hException));
            }
            new AusMicrocodeLog(LOG_INFO, 12, hException).writeEntry(null);
        }
    }

    private String getUniqueSourceName() {
        return WIZARD_FRAME_TASKLET + '.' + String.valueOf(this.lastUniqueIdNum++);
    }
}

